<?php

namespace App\Http\Controllers;

use App\Models\SystemSetting;
use App\Services\GitBookJwtService;

class SupportPageController extends Controller
{
    /**
     * Constructor for the SupportPageController class.
     *
     * @param GitBookJwtService $jwtService The JWT service for GitBook.
     */
    public function __construct(protected GitBookJwtService $jwtService) {}

    /**
     * Retrieves the system settings related to support links and renders the support index view.
     *
     * @return \Illuminate\Contracts\View\View The rendered support index view.
     */
    public function index()
    {
        $systemSettings = SystemSetting::whereIn('slug', ['api_guide_url', 'help_guide_url', 'chatbot_url', 'support_email'])->pluck('value', 'slug');
        $supportLinks = $systemSettings->toArray();
        $jwtToken = $this->jwtService->generateJwtForGitBook('api');

        return view('support.index', ['supportLinks' => $supportLinks, 'jwtToken' => $jwtToken]);
    }
}
