<?php

namespace App\Http\Controllers\SoftwareLicense\Zoom;


use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Services\SoftwareLicense\ImportedAssets\Zoom\ZoomMeetingService;
use Illuminate\Http\Request;

class ZoomMeetingController extends Controller
{
    public function __construct(protected ZoomMeetingService $service)
    {
    }

    /**
     * Retrieves the monthly user meetings for a given user ID.
     *
     * @param int $userId The ID of the user.
     * @return \Illuminate\Contracts\View\View The view for the member-hosted meetings page with the specified user ID.
     */
    public function getMonthlyUserMeetings($userId)
    {
        return view('software-license.zoom.member-hosted-meetings', ['host_id' => $userId]);
    }

    /**
     * Retrieves the monthly user meetings data.
     *
     * @param Request $request The HTTP request object.
     * @throws None
     * @return ReportJsonResponse The JSON response containing the monthly user meetings data.
     */
    public function getMonthlyUserMeetingsData(Request $request)
    {
        request()->validate([
            'host_id' => 'required'
        ]);

        $filteredData   = $this->service->data(request('host_id'));
        $meetings         =  $filteredData['meetings'];

        $start          = request('start');
        $data           = [];

        if (!empty($meetings)) {
            $data = $this->service->getMonthWiseUserMeetingsData($meetings, $start, $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count'], 500);
    }
}
