<?php

namespace App\Http\Controllers\SoftwareLicense;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\SoftwareLicense\LicenseDocumentService;
use App\Http\Requests\SoftwareLicense\LicenseDocumentRequest;
use App\Http\Responses\DataTableJsonResponse;

/**
 * Software License Document Controller
 */
class SoftwareLicenseDocumentController extends Controller
{

    protected $licenseDocumentService;

    /**
     * Constructor for SoftwareLicense Document Controller
     *
     * @param LicenseDocumentService $licenseDocumentService
     */
    public function __construct(LicenseDocumentService $licenseDocumentService)
    {
        $this->licenseDocumentService = $licenseDocumentService;
    }

    /**
     * List Software License documents
     *
     * @param object $request
     *
     * @return object
     */
    public function list(Request $request)
    {
        $licenseId          = $request['form']['id'];
        $documentData       = $this->licenseDocumentService->getLicenseDocuments($licenseId);
        $licenseDocuments   =  $documentData['licenseDocuments'];
        $totalData          = $documentData['count'];

        $start  = request('start');
        $data   = [];

        if (!empty($licenseDocuments)) {
            $data = $this->licenseDocumentService->getLicensesDocumentData($licenseDocuments, $start, $data);
        }

        return new DataTableJsonResponse($request->input('draw'), $data, $totalData);
    }

    /**
     * Remove Software License documents
     *
     * @param object $request
     *
     * @return object
     */
    public function remove(Request $request)
    {
        $response = $this->licenseDocumentService->removeDocumentFromLicense($request->id);

        if ($response['status']) {
            return redirect()->route('software-assets.edit', $response['license_id'])->with('message', 'Asset document removed successfully.');
        } else {
            return redirect()->route('software-assets.edit', $response['license_id'])->with('error', 'Opertaion failed');
        }
    }

    /**
     * Download License Document
     * @param int $id The identifier for the license document to download
     *
     * @return void
     */
    public function download($id)
    {
        $licenseDocument = $this->licenseDocumentService->getLicenseDocument($id);

        return response()->download(storage_path('app/public/software-assets/' . $licenseDocument->file_name));
    }

    /**
     * Add new documents to the license
     *
     * @param object $request
     *
     * @return object
     */
    public function add(LicenseDocumentRequest $request)
    {
        if ($request->hasfile('software_liceneses_documents')) {

            foreach ($request->file('software_liceneses_documents') as $file) {
                $name = request('name') . '-' . time() . '.' . $file->extension();
                $file->move(storage_path() . '/app/public/software-assets', $name);
                $this->licenseDocumentService->saveDocuments($name, request('software_license_id'));
            }

            return redirect()->route('software-assets.edit', request('software_license_id'))->with('message', 'Asset document added successfully.');
        }

        return redirect()->route('software-assets.edit', request('software_license_id'))->with('error', 'Opertaion failed');
    }
}
