<?php

namespace App\Http\Controllers\Settings\SystemSettings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ApiCredential;

class TeqtivitySlackNotificationAppController extends Controller
{
    /**
     * Retrieves the index view for the API credentials.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $credentials = ApiCredential::where('slug', 'teqtivity_slack_notification_app')->first();

        if ($credentials) {
            return view('settings.teq-slack-notification-app.index', compact('credentials'));
        }

        return redirect()->route('teqtivity-slack-notification-app.create');
    }

    /**
     * Create a new resource.
     *
     * @throws Some_Exception_Class description of exception
     * @return Some_Return_Value
     */
    public function create()
    {
        $credential = ApiCredential::where('slug', 'teqtivity_slack_notification_app')->first();
        if ($credential) {
            return redirect('teqtivity-slack-notification-app/' . $credential->id . '/edit');
        }
        return view('settings.teq-slack-notification-app.create');
    }

    /**
     * Store the API credential information.
     *
     * @param Request $request The HTTP request object.
     * @throws Some_Exception_Class Description of the exception (if any).
     * @return RedirectResponse Redirects to the specified route with a success message.
     */
    public function store(Request $request)
    {
        $request->validate([
            'user_name' => 'required',
            'password' => 'required',
        ]);

        ApiCredential::create([
            'api_name'  => 'Teqtivity Slack Notification App',
            'slug'      => 'teqtivity_slack_notification_app',
            'user_name' => $request->user_name,
            'password'  => $request->password,
        ]);

        return redirect()->route('teqtivity-slack-notification-app.index')->with('message', __('message.created'));
    }

    /**
     * Edit an API credential.
     *
     * @param int $id The ID of the API credential to be edited.
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View The view for editing the API credential.
     */
    public function edit($id)
    {
        $credential = ApiCredential::find($id);

        return view('settings.teq-slack-notification-app.edit', compact('credential'));
    }

    /**
     * Update the specified credential in the database.
     *
     * @param Request $request The request object containing the data.
     * 
     * @throws Some_Exception_Class A description of the exception that can be thrown.
     * @return \Illuminate\Http\RedirectResponse The redirect response to the specified route.
     */
    public function update(Request $request)
    {
        $request->validate([
            'user_name' => 'required',
        ]);
        $credential = ApiCredential::where('slug', 'teqtivity_slack_notification_app')->first();

        $credential->update([
            'user_name' => $request->user_name,
            'password'  => $request->password ?? $credential->password,
        ]);

        return redirect()->route('teqtivity-slack-notification-app.index')->with('message', __('message.updated'));
    }
}
