<?php

namespace App\Http\Controllers\Settings\SystemSettings;

use App\Http\Controllers\Controller;
use App\Models\SystemSetting;
use Illuminate\Http\Request;

class SupportSettingsController extends Controller
{
    /**
     * Display the support page settings view.
     *
     * @return \Illuminate\View\View The view for the support page settings
     */
    public function index()
    {
        $systemSettings = SystemSetting::whereIn('slug', ['chatbot_url', 'support_email'])->pluck('value', 'slug');
        $supportLinks = $systemSettings->toArray();

        return view('settings.system-settings.support-page', ['supportLinks' => $supportLinks]);
    }

    /**
     * Store or update support page settings.
     *
     * @param \Illuminate\Http\Request $request The incoming request instance
     *
     * @return \Illuminate\Http\RedirectResponse The redirect response with a success message
     */
    public function store(Request $request)
    {
        $request->validate([
            'chatbot_url'     => 'nullable|url',
            'support_email'   => 'nullable|email',
        ]);

        // Exclude the token.
        $requestData = $request->except('_token');

        foreach ($requestData as $key => $value) {
            // Convert key to snake_case for slug.
            $slug = snake_case($key);

            // Convert key to human-readable name.
            $name = ucwords(str_replace('_', ' ', $key));

            // Find or create a SystemSetting with the given slug.
            SystemSetting::updateOrCreate(
                ['slug' => $slug],
                ['name' => $name, 'value' => $value]
            );
        }

        return redirect()->route('support-page.index')->with('message', 'Settings updated');
    }
}
