<?php

namespace App\Http\Controllers\Settings\History;

use App\Http\Controllers\Controller;
use App\Http\Responses\DataTableJsonResponse;
use App\Services\Settings\History\UserRoleChangeHistoryService;

class UserRoleChangeHistoryController extends Controller
{
    /**
     * Constructs a new instance of the class.
     *
     * @param UserRoleChangeHistoryService $service The data service for role change history.
     */
    public function __construct(protected UserRoleChangeHistoryService $service) {}

    /**
     * Index function.
     *
     * @return View
     */
    public function index()
    {
        return view('settings.history.user-role-change-history.index');
    }

    /**
     * Generates the function comment for the data function.
     *
     * @return string The JSON-encoded data.
     */
    public function data()
    {
        $filteredData = $this->service->data();
        $histories = $filteredData['histories'];
        $totalData = $filteredData['count'];
        $data = empty($histories) ? [] : $this->service->getData($histories, request('start') ?? 0);

        return new DataTableJsonResponse(request()->input('draw'), $data, $totalData);
    }

    /**
     * Export the data to a CSV file.
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();

        $dataCollection = collect();
        $filteredData = $this->service->getExportData();
        $filteredData->chunk(5000, function ($chunkData) use ($dataCollection) {
            $dataCollection->push($this->service->getReportExportData($chunkData));
        });

        return exportToCsv($dataCollection->toArray());
    }
}
