<?php

namespace App\Http\Controllers\Settings\History;

use App\Http\Controllers\Controller;
use App\Http\Responses\DataTableJsonResponse;
use App\Services\Settings\History\UserLoginHistoryService;
use Illuminate\Http\Request;

class UserLoginHistoryController extends Controller
{
    /**
     * UserLoginHistoryController constructor.
     *
     * @param UserLoginHistoryService $service
     *
     */
    public function __construct(protected UserLoginHistoryService $service) {}

    /**
     * Listing User Login Histories details.
     *
     * @return view
     */
    public function index()
    {
        return view('settings.history.user-login-history.index');
    }

    /**
     * User Login History Data
     *
     * @param Request $request
     */
    public function data(Request $request)
    {
        $filteredData = $this->service->data();
        $histories    = $filteredData['assets'];
        $totalData    = $filteredData['count'];
        $data         = [];

        if (!empty($histories)) {
            $data = $this->service->getHistoryData($histories, request('start'), $data);
        }

        return new DataTableJsonResponse($request->input('draw'), $data, $totalData);
    }

    /**
     * Export the User Login History
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        $dataCollection     = collect();
        $allData            = $this->service->getExportData();
        $allData->chunk(5000, function ($chunkData) use ($dataCollection) {
            $dataCollection->push($this->service->getExportHistoryData($chunkData));
        });

        return exportToCsv($dataCollection->toArray());
    }
}
