<?php

namespace App\Http\Controllers\Settings\History;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Services\Settings\History\UserHistoryService;

class UserHistoryController extends Controller
{
    /**
     * Constructs a new instance of the class.
     *
     * @param UserHistoryService $service The UserHistoryService instance.
     */
    public function __construct(protected UserHistoryService $service) {}

    /**
     * load view file
     *
     * @return view
     */
    public function index()
    {
        return view('settings.history.user-history.index');
    }

    /**
     * Fetch data for the list
     *
     * @return ReportJsonResponse
     */
    public function data()
    {
        $filteredData = $this->service->data();
        $history =  $filteredData['history'];
        $data = [];

        if (!empty($history)) {
            $data = $this->service->getReportData($history, request('start'));
        }

        return new ReportJsonResponse(request()->input('draw'), $data, $filteredData['count']);
    }
}
