<?php

namespace App\Http\Controllers\Settings\History;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Services\Settings\History\SystemHistoryService;

class SystemHistoryController extends Controller
{
    /**
     * Constructor for the class.
     *
     * @param SystemHistoryService $service
     */
    public function __construct(protected SystemHistoryService $service) {}

    /**
     * load view file
     *
     * @return view
     */
    public function index()
    {
        $historyAction = config('history-action');
        $historyAction = array_sort($historyAction, 'label', SORT_ASC); // sort by label

        return view('settings.history.system-history.index', compact('historyAction'));
    }

    /**
     * Fetch data for the list
     *
     * @return ReportJsonResponse
     */
    public function data()
    {
        $filteredData = $this->service->data();
        $history =  $filteredData['history'];
        $data = [];

        if (!empty($history)) {
            $data = $this->service->getReportData($history, request('start'));
        }

        return new ReportJsonResponse(request()->input('draw'), $data, $filteredData['count']);
    }
}
