<?php

namespace App\Http\Controllers\Settings\History;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Services\Settings\History\SoftwareAssetHistoryService;

class SoftwareAssetHistoryController extends Controller
{
    /**
     * Constructor for the class.
     *
     * @param SoftwareAssetHistoryService $service The software asset history service.
     */
    public function __construct(protected SoftwareAssetHistoryService $service)
    {
    }

    /**
     * Render the view for the software asset history page.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $historyAction = config('software-asset-history-action');
        $historyAction = array_sort($historyAction, 'label', SORT_ASC); // Sort by label.

        return view('settings.history.software-asset-history.index', compact('historyAction'));
    }

    /**
     * Fetch data for the list.
     *
     * @return ReportJsonResponse
     */
    public function data()
    {
        $filteredData = $this->service->data();
        $history = $filteredData['history'];
        $data = [];

        if (!empty($history)) {
            $data = $this->service->getReportData($history, request('start'));
        }

        return new ReportJsonResponse(request()->input('draw'), $data, $filteredData['count']);
    }
}
