<?php

namespace App\Http\Controllers\Settings\History;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Services\Settings\History\PurgedAssetsHistoryService;

class PurgedAssetHistoryController extends Controller
{
    /**
     * Constructor for the class.
     *
     * @param PurgedAssetsHistoryService $service The PurgedAssetsHistoryService instance.
     */
    public function __construct(protected PurgedAssetsHistoryService $service)
    {
    }

    /**
     * Retrieves the view for the index page of the purged assets history settings.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        return view('settings.history.purged-assets-history.index');
    }

    /**
     * Fetch data for the list
     *
     * @return ReportJsonResponse
     */
    public function data()
    {
        $filteredData = $this->service->data();
        $history = $filteredData['history'];
        $data = [];

        if (!empty($history)) {
            $data = $this->service->getReportData($history, request('start'));
        }

        return new ReportJsonResponse(request()->input('draw'), $data, $filteredData['count']);
    }
}
