<?php

namespace App\Http\Controllers\Settings\History;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Services\Settings\History\LocationHistoryService;

class LocationHistoryController extends Controller
{
    /**
     * Constructor for the class
     *
     * @param LocationHistoryService $service The LocationHistoryService object.
     */
    public function __construct(protected LocationHistoryService $service) {}

    /**
     * Load view file
     *
     * @return view
     */
    public function index()
    {
        return view('settings.history.location-history.index');
    }

    /**
     * Fetch data for the list
     *
     * @return ReportJsonResponse
     */
    public function data()
    {
        $filteredData = $this->service->data();
        $history =  $filteredData['history'];
        $data = [];

        if (!empty($history)) {
            $data = $this->service->getReportData($history, request('start'));
        }

        return new ReportJsonResponse(request()->input('draw'), $data, $filteredData['count']);
    }
}
