<?php

namespace App\Http\Controllers\Settings\History;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Services\Settings\History\ApiRequestHistoryService;
use Illuminate\Http\Request;

class ApiRequestHistoryController extends Controller
{
    /**
     * Constructor method.
     *
     * @param ApiRequestHistoryService $service api request history service.
     */
    public function __construct(protected ApiRequestHistoryService $service) {}

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('settings.history.api-request-history.index');
    }

    /**
     * To get table data.
     *
     * @return \Illuminate\Http\Response
     */
    public function data(Request $request)
    {
        $filteredData = $this->service->data();
        $apiRequestHistories =  $filteredData['apiHistories'];
        $data = [];

        if (!empty($apiRequestHistories)) {
            $data = $this->service->getApiRequestData($apiRequestHistories, request('start'), $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }
}
