<?php

namespace App\Http\Controllers\Security\Crowdstrike\Reports;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use Illuminate\Http\Request;
use App\Services\Security\Crowdstrike\Reports\SensorDetectionService;

class SensorDetectionReportController extends Controller
{
    
    private $service;
    
    /**
     * constructor for Crowdstrike Report Controller
     * 
     * @param SensorDetectionService $service
     * 
     */
    public function __construct(SensorDetectionService $service)
    {
        $this->service = $service;
    }

    /**
     * List page for sensor detection report
     *
     * @return view file
     */
    public function index()
    {
        return view('security.crowdstrike.sensor-detection.index');
    }

    /**
     * Fetch data for sensor detection report
     *
     * @return object
     */
    public function data(Request $request)
    {
        $filteredData = $this->service->data();

        if (!empty($filteredData['assets'])) {
            $data = $this->service->getReportData($filteredData['assets'], request('start'));
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }


    /**
     * Export the sensor detection data.
     *
     * @return object
     */
    public function  export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $data = [];
        $datas = collect();
        
        $assets =  $this->service->exportData();

        $assets->chunk(5000, function ($assetChunks) use ($data, $datas) {
            $datas->push($this->service->getReportExportData($assetChunks, $data));
        });
        
        return exportToCsv($datas->toArray());
    }

}