<?php

namespace App\Http\Controllers\Security\Crowdstrike\Reports;

use App\Http\Controllers\Controller;
use App\Services\Security\Crowdstrike\Reports\CrowdstrikeReportService;

class CrowdstrikeReportController extends Controller
{
    
    private $crowdstrikeReportService;
    
    
    /**
     * constructor for Crowdstrike Report Controller
     * 
     * @param CrowdstrikeReportService $crowdstrikeReportService
     * 
     */
    public function __construct(CrowdstrikeReportService $crowdstrikeReportService)
    {
        $this->crowdstrikeReportService = $crowdstrikeReportService;
    }

    /**
     * Retrieves the vulnerability fields based on the provided search parameters.
     *
     * @return \Illuminate\Http\JsonResponse Returns the vulnerability fields in JSON format.
     */
    public function getFilterVulnerabilityFields()
    {
        $search = request('search');
        $type = request('type');
        

        if (!empty($search)) {

            $result = $this->crowdstrikeReportService->getFilterVulnerabilityFields($search, $type);

            if (!$result->count()) {
                $result[] = ['id' => '0', 'text' => 'No result found'];
            }

            return response()->json($result);
        }
    }
}