<?php

namespace App\Http\Controllers\Security\Crowdstrike;

use App\Http\Controllers\Controller;
use App\Services\Security\Crowdstrike\CveDataService;

class ActiveCveController extends Controller
{
    
    private $service;
    
    /**
     * constructor for Crowdstrike Report Controller
     * 
     * @param CveDataService $service
     * 
     */
    public function __construct(CveDataService $activeCveService)
    {
        $this->service = $activeCveService;
    }


    /**
     * Retrieves the details of a single active CVE.
     *
     * @param int $id The ID of the CVE.
     * @throws Some_Exception_Class A description of the exception that can be thrown.
     * @return View The view containing the details of the CVE.
     */
    public function getSingleActiveCveDetails($id)
    {
        $cveData      = $this->service->getSingleCveData($id);
        $cveAssets    = $this->service->getcveAssets($cveData->cve_id);
        $cveAssetsIds = $cveAssets->pluck('asset_id')->toArray();
        $totalAssetsCount = count($cveAssetsIds);
        $csvWidgetData = $this->service->getCsvDetailAssetsWidgetData($cveAssetsIds);

        return view('security.crowdstrike.active-cve.detail', compact('cveData', 'totalAssetsCount', 'csvWidgetData'));
    }

}