<?php

namespace App\Http\Controllers\Revivn;

use App\Http\Controllers\Controller;
use App\Services\Revivn\RevivnPickupReportService;
use Illuminate\Http\Request;
use App\Http\Responses\ReportJsonResponse;
use Exception;

class RevivnPickupController extends Controller
{
    public function __construct(RevivnPickupReportService $serviceClass)
    {
        $this->serviceClass = $serviceClass;
    }
    
    /**
     * Display the main index view for Revivn Pickups.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        return view('revivn.revivn-pickups');
    }

    /**
     * Generate the function comment for the given function body.
     *
     * @param Request $request The request object.
     * @throws Some_Exception_Class Description of exception.
     * @return ReportJsonResponse The response object.
     */
    public function data(Request $request)
    {
        setUnlimitedExecutionTimeAndMemoryLimit();

        $filteredData = $this->serviceClass->data(1);
        $pickups = $filteredData['pickups'];

        $start = $request->input('pickups');
        $data = [];

        if (!empty($pickups)) {
            $data = $this->serviceClass->getReportData($pickups, $start, $data, 1);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }
    

    /**
     * Export data to CSV format.
     *
     * This method sets the maximum execution time and memory limit to handle large datasets.
     * It collects the export data from the service class, processes it, and then exports it to CSV.
     *
     * @return \Symfony\Component\HttpFoundation\StreamedResponse
     */
    public function export()
    {
        // Set maximum execution time and memory limit
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $data = [];
        $datas = collect();
        $filteredData = $this->serviceClass->data(); 

        $filteredData->chunk(5000, function ($dataChunks) use ($data, $datas) {
            $datas->push($this->serviceClass->getReportData($dataChunks, 0, $data));
        });

        return exportToCsv($datas->toArray()); 
    }

}
