<?php

namespace App\Http\Controllers\Revivn;

use App\Http\Controllers\Controller;
use App\Services\Revivn\RevivnDevicesAutoCreatedService;
use Illuminate\Http\Request;
use App\Http\Responses\ReportJsonResponse;

class RevivnDevicesAutoCreatedController extends Controller
{

    public function __construct(protected RevivnDevicesAutoCreatedService $service)
    {
    }

    /**
     * Show received assets
     *
     * @return view
     */
    public function index()
    {
        $search = [];
        if (request('pickup')) {
            $search['pickup'] = request('pickup');
        }
        return view('revivn.revivn-assets-auto-created', compact('search'));
    }

    /**
     * Generate the function comment for the given function body.
     *
     * @param Request $request The request object.
     * @throws Some_Exception_Class Description of exception.
     * @return ReportJsonResponse The response object.
     */
    public function data(Request $request)
    {
        setUnlimitedExecutionTimeAndMemoryLimit();

        $filteredData = $this->service->data(1);
        $assets = $filteredData['assets'];

        $start = $request->input('start');
        $data = [];

        if (!empty($assets)) {
            $data = $this->service->getReportData($assets, $start, $data, 1);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count']);
    }

    /**
     * Export data to CSV.
     *
     * This method sets the maximum execution time and memory limit to handle large exports.
     * It retrieves filtered data from the service class and prepares it for export.
     *
     * @return string The exported data in CSV format.
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();

        $datas = collect();
        $data = [];

        $filteredData = $this->service->data();

        $filteredData->chunk(5000, function ($dataChunks) use ($data, $datas) {
            $datas->push($this->service->getReportData($dataChunks, 0, $data));
        });

        return exportToCsv($datas->toArray());
    }
}
