<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\AssetsAssignedService;
use App\Services\Reports\UseTaxService;

/**
 * Controller class for `Use Tax` Report.
 * This report showing where the assets (location each tablet is in and how long it has been there)
 * are for Use Tax purposes.
 */
class UseTaxController extends Controller
{
    use DataAndExportControllerTrait;
    /**
     * Constructs a new instance of the class.
     *
     * @param UseTaxService $service The UseTaxService object.
     * @param AssetsAssignedService $assetAssignedService The AssetsAssignedService object.
     */
    public function __construct(protected UseTaxService $service, protected AssetsAssignedService $assetAssignedService) {}

    /**
     * index
     *
     * @return void
     */
    public function index()
    {
        $statuses =  $this->service->getAssetStatus();

        return view('reports.use-tax.index', compact('statuses'));
    }
}
