<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\UpcomingRefreshService;
/**
 * A report to show upcoming refresh assets that are 2.5 years or more older.
 */
class UpcomingRefreshController extends Controller
{
    use DataAndExportControllerTrait;

    /**
     * Constructor method.
     *
     * @param UpcomingRefreshService $service upcoming refresh service.
     */
    public function __construct(protected UpcomingRefreshService $service) {}

    /**
     * Display index page.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $ageFilterOptions = config('reports.upcoming_refresh.age_filter_options');

        return view('reports.upcoming-refresh.index', compact('ageFilterOptions'));
    }
}
