<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\UnrepairableService;

class UnrepairableController extends Controller
{
    use DataAndExportControllerTrait;
    /**
     * Constructor for the class.
     *
     * @param UnrepairableService $service The UnrepairableService object.
     */
    public function __construct(protected UnrepairableService $service) {}

    /**
     * Display the index view for the unrepairable assets report.
     *
     * @return \Illuminate\View\View The view for the unrepairable assets report index
     */
    public function index()
    {
        // Get date range from the service.
        $dateFrom = $this->service->getFromDate();
        $dateTo = $this->service->getToDate();

        $widgetCountData = $this->service->getWidgetCountData($dateFrom, $dateTo);

        return view('reports.unrepairable.index', compact('widgetCountData', 'dateFrom', 'dateTo'));
    }

    /**
     * Retrieve the widget count data for the specified date range.
     *
     * @return \Illuminate\Http\JsonResponse The JSON response containing the widget count data
     */
    public function getWidgetCount()
    {
        $dateFrom = request('date_from');
        $dateTo = request('date_to');

        $widgetCountData = $this->service->getWidgetCountData($dateFrom, $dateTo);

        return response()->json($widgetCountData);
    }
}
