<?php

namespace App\Http\Controllers\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\ShareViaEmailRequest;
use App\User;
use Illuminate\Support\Facades\Notification;
use App\Notifications\ShareReports;

class ShareReportController extends Controller
{

    /**
     * Send the report via email to the specified recipients.
     *
     * @param \App\Http\Requests\ShareViaEmailRequest $request The incoming request instance
     *
     * @return \Illuminate\Http\RedirectResponse The redirect response with a success message
     */
    public function mail(ShareViaEmailRequest $request)
    {
        // if ($request->file_name == '') {
        //     return redirect()->back()->withError('File is missing .Please try again');
        // }
        // if (count($request->users) == 0) {
        //     return redirect()->back()->withError('Please select atleast one recipient');
        // }

        $fileName = $request->file_name;
        $title   = $request->title;
        // $recipients = explode(',', $request->users);
        $recipients = $request->users;
        if (!empty($recipients)) {
            foreach ($recipients as $recipient) {
                Notification::route('mail', trim($recipient))->notify(new ShareReports($fileName, $title));
            }
        }

        return redirect()->back()->with('message',  ' Report sent successfully');
    }

    /**
     * Retrieve a list of active users with email addresses matching the search term.
     *
     * @param \Illuminate\Http\Request $request The incoming request instance
     *
     * @return \Illuminate\Http\JsonResponse The JSON response containing the list of matching users
     */
    public function getUsers(Request $request)
    {
        // $host = request()->getHttpHost();

        $query = User::active()->select('id', 'email as text');
        // ->Where('email', 'like', '%@' . $host . '%');
        if (!empty($request->searchTerm)) {
            $query = $query->Where('email', 'like', '%' . $request->searchTerm . '%');
        }

        $users = $query->limit(15)->get();

        return response()->json($users);
    }
}
