<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\RepairAndRecoveryService;

/**
 * A report to show how long an asset has been in repair.
 */
class RepairAndRecoveryController extends Controller
{
    use DataAndExportControllerTrait;
    /**
     * Initialize the controller with the RepairAndRecoveryService.
     *
     * @param \App\Services\RepairAndRecoveryService $service The service to manage repair and recovery operations
     */
    public function __construct(protected RepairAndRecoveryService $service) {}

    /**
     * Display the index view for the repair and recovery report.
     *
     * @return \Illuminate\View\View The view for the repair and recovery report index
     */
    public function index()
    {
        // Get date range.
        $dateFrom = $this->service->getFromDate();
        $dateTo = $this->service->getToDate();

        $widgetCountData = $this->service->getWidgetCountData($dateFrom, $dateTo);

        return view('reports.repair-and-recovery.index', compact('widgetCountData', 'dateFrom', 'dateTo'));
    }

    /**
     * Retrieve the widget count data for the specified date range.
     *
     * @return \Illuminate\Http\JsonResponse The JSON response containing the widget count data
     */
    public function getWidgetCount()
    {
        $dateFrom = request('date_from');
        $dateTo = request('date_to');

        $widgetCountData = $this->service->getWidgetCountData($dateFrom, $dateTo);

        return response()->json($widgetCountData);
    }
}
