<?php

namespace App\Http\Controllers\Reports\OperatingSystemCompliance;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Models\AssetStatus;
use App\Models\AssetType;
use App\Models\MakeAndModel;
use App\Models\TechnicalSpecs;
use App\Services\OperatingSystemCompliance\AndroidComplianceService;

class AndroidComplianceReportController extends Controller
{
    use DataAndExportControllerTrait;
    public $service;

    public function __construct(AndroidComplianceService $osService)
    {
        $this->service = $osService;
    }

    /**
     * Listing Page for the report
     */
    public function index()
    {
        $assetTypes = AssetType::valid()->orderBy('name', 'ASC')->get();
        $hardwareStds = MakeAndModel::valid()->orderBy('name', 'ASC')->get();
        $techSpecs = TechnicalSpecs::valid()->orderBy('details', 'ASC')->get();
        $assetStatus = AssetStatus::reportStatus()->orderBy('name', 'ASC')->get();
        $osVersions = $this->service->getFilterData('os_version')->sortBy('os_version');
        $platforms = $this->service->getFilterData('platform')->sortBy('platform');

        return view('reports.os-compliance.android-compliance-report', compact('assetTypes', 'hardwareStds', 'techSpecs', 'assetStatus', 'osVersions', 'platforms'));
    }

    /**
     * Export report result to csv
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $data = [];
        $datas = collect();
        $filteredData = $this->service->exportData();

        $filteredData->chunk(5000, function ($complianceReportChunks) use ($data, $datas) {
            $datas->push($this->service->getReportExportData($complianceReportChunks, 0, $data));
        });

        return exportToCsv($datas->toArray());
    }
}
