<?php

namespace App\Http\Controllers\Reports\NewHire;

use App\Http\Controllers\Controller;
use App\Services\NewHireEmployeesData;
use App\Models\Department;
use Illuminate\Http\Request;
use App\Services\NewHire\NewHireForecastingToolData;
use Carbon\Carbon;

/**
 * Controller class for Active Users Without Assets Report
 */
class NewHireForecastingToolController extends Controller
{
    protected $activeUsersReportData;

    /**
     * Initialize the controller with the NewHireForecastingToolData service.
     *
     * @param \App\Services\NewHireForecastingToolData $forecastingToolData The service to manage new hire forecasting data
     */
    public function __construct(protected NewHireForecastingToolData $forecastingToolData)
    {
    }

    /**
     * Display the index view for the new hire forecasting tool report.
     *
     * @return \Illuminate\View\View The view for the new hire forecasting tool report
     */
    public function index()
    {
        $departments = Department::orderBy('name')->get();

        $forecastingData = [];
        $totalCost = '';
        $startMonth = '';
        $endMonth = '';

        return view('reports.new-hire.forecasting-tool', compact('departments', 'forecastingData', 'totalCost', 'startMonth', 'endMonth'));
    }

    /**
     * Retrieve and format the data for the new hire forecasting tool report.
     *
     * @return \Illuminate\View\View The view for the new hire forecasting tool report with the formatted data
     */
    public function data()
    {
        $filteredData = $this->forecastingToolData->filter();
        $forecastingData = $filteredData['forecastingData'];

        // Commented Unused: $totalData = $filteredData['count'];.
        // Commented Unused: $totalFiltered = $totalData;.
        // Commented Unused: $start = request('start');.
        $data = [];

        if (!empty($forecastingData)) {
            $data = $this->forecastingToolData->getData($data, $forecastingData);
        }

        $departments = Department::orderBy('name')->get();
        $forecastingData = $data;
        $totalCost = array_sum((array_column($data, 'cost_cal')));
        $startMonth =  $this->forecastingToolData->convertMonthToDate(request('start_month_year'), 'month');
        $endMonth =  $this->forecastingToolData->convertMonthToDate(request('end_month_year'), 'month');
        $formData = $this->forecastingToolData->getInputData();

        return view('reports.new-hire.forecasting-tool', compact('departments', 'forecastingData', 'totalCost', 'startMonth', 'endMonth', 'formData'));
    }
}
