<?php

namespace App\Http\Controllers\Reports\NewHire;

use App\Http\Controllers\Controller;
use App\Http\Responses\DataTableJsonResponse;
use Illuminate\Http\Request;
use App\Services\NewHire\NewHireEmployeesForecastingData;

/**
 * Controller class for Active Users Without Assets Report
 */
class NewHireForecastingController extends Controller
{
    protected $activeUsersReportData;

    public function __construct(NewHireEmployeesForecastingData $newHireEmployeesForecastingData)
    {
        $this->newHireEmployeesForecastingData = $newHireEmployeesForecastingData;
    }

    /**
     * Displays a list of devices needed based on how many people are starting
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('reports.new-hire.new-hire-employees-forecasting');
    }

    /**
     * Taking the data to the `Active Users with No Assets Assigned` report
     *
     * @param Illuminate\Http\Request $request
     * @return Http\Response
     */
    public function data(Request $request)
    {
        $newhireForecastingData = $this->newHireEmployeesForecastingData->getNewhireForecastingData();
        $newHires   = $newhireForecastingData['newHires'];
        $totalData  = $newHires->count();
        
        $data   = [];

        if (!empty($newHires)) {
            $data = $this->newHireEmployeesForecastingData->formatData($newHires, $data);
        }

        return new DataTableJsonResponse($request->input('draw'), $data, $totalData);
    }
}
