<?php

namespace App\Http\Controllers\Reports\NewHire;

use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\NewHire\AverageDeploymentTimeService;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Log;

class AverageDeploymentTimeController
{
    use DataAndExportControllerTrait;

    /**
     * Initializes a new instance of the class.
     *
     * @param AverageDeploymentTimeService $service The instance of AverageDeploymentTimeService.
     */
    public function __construct(protected AverageDeploymentTimeService $service) {}

    /**
     * Index function description.
     *
     * @return View
     */
    public function index()
    {
        // set date to show last 30 days data by default
        $dateFrom = Carbon::now()->subDays(30)->format(config('date.formats.read_date_format'));

        return view('reports.new-hire.average-deployment-time', compact('dateFrom'));
    }

    /**
     * Retrieves widget data and returns it as a JSON-encoded string.
     *
     * @throws Exception if an error occurs during the retrieval process.
     * @return string the JSON-encoded widget data.
     */
    public function widgetData()
    {
        try {
            $data = $this->service->getWidgetData();

            return json_encode($data);
        } catch (Exception $e) {
            Log::error($e->getMessage());
        }
    }
}
