<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\LostOrStolenValueService;

/**
 * A report to show how many devices were lost or stolen and how much is the lost value.
 */
class LostOrStolenValueController extends Controller
{

    use DataAndExportControllerTrait;
    /**
     * Initialize the controller with the LostOrStolenValueService.
     *
     * @param \App\Services\LostOrStolenValueService $service The service to manage lost or stolen assets
     */
    public function __construct(protected LostOrStolenValueService $service) {}

    /**
     * Display the index view for the lost or stolen value report.
     *
     * @return \Illuminate\View\View The view for the lost or stolen value report index
     */
    public function index()
    {
        // Get date range from the service.
        $dateFrom = $this->service->getFromDate();
        $dateTo = $this->service->getToDate();

        $widgetCountData = $this->service->getWidgetCountData($dateFrom, $dateTo);

        return view('reports.lost-or-stolen-value.index', compact('widgetCountData', 'dateFrom', 'dateTo'));
    }

    /**
     * Retrieve the widget count data for the specified date range.
     *
     * @return \Illuminate\Http\JsonResponse The JSON response containing the widget count data
     */
    public function getWidgetCount()
    {
        $dateFrom = request('date_from');
        $dateTo = request('date_to');

        $widgetCountData = $this->service->getWidgetCountData($dateFrom, $dateTo);

        return response()->json($widgetCountData);
    }
}
