<?php

namespace App\Http\Controllers\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Facades\App\Models\Asset;

class LinkedDevicesController extends Controller
{
    public function index()
    {
        $childAssets = Asset::has('parentAsset')->with('makeAndModel.manufacturer', 'technicalSpec', 'parentAsset.makeAndModel.manufacturer', 'parentAsset.technicalSpec')->get();
        return view('reports.linked-devices', compact('childAssets'));
    }
}
