<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\InStockComputerService;

/**
 * Controller class for assets - computers based on status 
 */
class InStockComputersController extends Controller
{
    use DataAndExportControllerTrait;

    /**
     * Constructor method.
     *
     * @param InStockComputerService $service The in-stock computer service.
     */
    public function __construct(protected InStockComputerService $service) {}

    /**
     * Display asset listing for computers based on status and type.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $search = [];

        if (request('status') || request('type')) {
            $search = $this->service->getSearchData(request('status'), request('type'));
        }

        return view('reports.instock-computers.index', compact('search'));
    }
}
