<?php

namespace App\Http\Controllers\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\DataTableJsonResponse;
use App\Http\Traits\SavedSearchTrait;
use App\Models\SavedSearch;
use Facades\App\Services\Dashboard\DashboardService;
use Facades\App\Services\Reports\Generator;
use Carbon\Carbon;
use App\User;
use Exception;
use Facades\App\Services\ExportManagement\ExportManagementService;
use Illuminate\Support\Facades\Auth;

class GeneratorController extends Controller
{
	use SavedSearchTrait;
	public function index()
	{
		$fieldsSelect = config('asset-fields.select');
		$fieldsBoolean = config('asset-fields.boolean');
		$fieldsDateFrom = config('asset-fields.dates_from');
		$fieldsRadioButton = config('asset-fields.radioButton');

		$userId = Auth::id();
		$user = User::with('userType')->find($userId);
		$savedFilters = SavedSearch::reportName('generator')->userSavedSearch($userId)->get();
		$viewAllFilters = SavedSearch::reportName('generator')->adminSavedSearch()->get();

		$search = [];
		$savedSearch = [];
		if (request('admin_saved_search') || request('user_saved_search')) {
			try {
				if (request('admin_saved_search')) {
					$savedSearch = SavedSearch::reportName('generator')->where('id', request('admin_saved_search'))->where('view_all', 1)->firstOrFail();
				}
				if (request('user_saved_search')) {
					$savedSearch = SavedSearch::reportName('generator')->where('id', request('user_saved_search'))->where('user_id', Auth::id())->whereNull('view_all')->firstOrFail();
				}
				$search = Generator::decodeSearch($savedSearch->parameters);
			} catch (Exception $e) {
				return redirect('/report/generator')->with('error', 'Search not found!');
			}
		} elseif (request('status')) { //this condition calls from dashboard
			$search = DashboardService::getSearch(request('status'), request('type'), request('searchData'));
		}
		return view('reports.generator', compact('fieldsSelect', 'fieldsDateFrom', 'fieldsBoolean', 'fieldsRadioButton', 'savedFilters', 'viewAllFilters', 'search', 'savedSearch', 'user'));
	}

	public function data(Request $request)
	{
		$filteredData	= Generator::data();
		$assets 		= $filteredData['assets'];
		$totalData 		= $filteredData['count'];

		$start	= request('start');
		$data 	= [];

		if (!empty($assets)) {
			$data = Generator::getAssetData($assets, $start, $data);
		}

		return new DataTableJsonResponse($request->input('draw'), $data, $totalData);
	}

	/**
	 * handles the export of files from report generator
	 * @return [type]
	 */
	public function export($saveExport = null)
	{
		setUnlimitedExecutionTimeAndMemoryLimit();

		$assetsAll = Generator::exportData();
		if (ExportManagementService::reportsLargeExport($assetsAll)) {
			return 'Your report will be generated in the background. Go to the <a target="_blank" href="/generated-exports/generator_report">Reports Page</a> to download the report.';
		}

		$data = [];
		$datas = collect();
		$chunkSize = 5000;
		$index = 0;
		$assetsAll->chunk($chunkSize, function ($assetsChunks) use ($data, $datas, $index, $chunkSize) {
			$datas->push(Generator::getExportAssetData($assetsChunks, $index, $data));
			$index = $index + $chunkSize;
		});

		// Used in report generator page "Send via email" feature.
		// To get the report file to attach in the email.
		if ($saveExport != null) {
			$title = 'Report Generator';

			return Generator::saveExport($datas->toArray(), $title);
		}

		return exportToCsv($datas->toArray());
	}

	/**
	 * Gets the parametrs for save the search
	 * @return
	 */
	public function getSavedSearchParameters()
	{
		return Generator::getSavedSearchParameters();
	}

	/**
	 * Gets the name for save the search
	 * @return string
	 */
	public function getSavedSearchReportName()
	{
		return 'generator';
	}
}
