<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\Reports\FleetAgeService;

class FleetAgeController extends Controller
{
    
    protected $service;
    
    /**
     * Constructs a new instance of the class.
     *
     * @param FleetAgeService $service The FleetAgeService instance.
     */
    public function __construct(FleetAgeService $service)
    {
        $this->service = $service;
    }
    
    /**
     * Report page for FleetAgeService
     * 
     * @return View
     */
    public function index()
    {
        $filterDataOptions = $this->service->getFilterDataOptions();
        $ageAndMonthData = $this->service->getAgeandMonthData();
        
        $data = $this->service->data($ageAndMonthData['months'], $ageAndMonthData['age']);
        $monthNames = collect($ageAndMonthData['months'])->flatten()->toArray();
 
        return view('reports.fleet-age.index', compact('filterDataOptions', 'monthNames', 'data'));
    }
}
