<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\FavouriteReport;
use Auth;

/**
 * Controller class for Adding Reports as favourite
 */
class FavouriteReportController extends Controller
{
    public function __invoke(Request $request)
    {
        $request->validate([
            'report_slug' => 'required'
        ]);

        // Find the favorite or create a new instance
        $favorite = FavouriteReport::firstOrNew(['user_id' => Auth::user()->id, 'report_slug' => $request->report_slug]);

        if ($favorite->exists) {
            // Favorite already exists, delete it
            $favorite->delete();

            return redirect(route('report.index'))->with('message', __('message.favourite_removed'));
        } else {
            // Favorite does not exist, save it
            $favorite->save();
            
            return redirect(route('report.index'))->with('message', __('message.favourite_added'));
        }
    }
}
