<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\ComputerDeployedService;

class ComputerDeployedController extends Controller
{
    use DataAndExportControllerTrait;
    /**
     * Constructs a new instance of the class.
     *
     * @param ComputerDeployedService $service The deployment service object.
     */
    public function __construct(protected ComputerDeployedService $service) {}

    /**
     * Display the index view for the computer deployed reports.
     *
     * @return \Illuminate\View\View The view for the computer deployed reports index
     */
    public function index()
    {
        return view('reports.computer-deployed.index');
    }
}
