<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\ComputerByStatusService;
use App\Services\Reports\Generator;

class ComputerByStatusController extends Controller
{
    use DataAndExportControllerTrait;

    /**
     * Constructs a new instance of the class.
     *
     * @param ComputerByStatusService $service The computer by status service.
     * @param Generator $reportGeneratorService The report generator service.
     */
    public function __construct(protected ComputerByStatusService $service, protected Generator $reportGeneratorService) {}

    /**
     * Retrieves the list of computers by status and displays it in the index view.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View The index view with the list of computers by status.
     */
    public function index()
    {
        $search = [];

        if (request('status')) {
            $search = $this->reportGeneratorService->getSearch(request('status'), request('type'), request('hardware_standard') ?? null, request('department') ?? null);
        }

        return view('reports.computer-by-status.index', ['search' => $search]);
    }
}
