<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\ComputerByAgeService;

class ComputerByAgeController extends Controller
{
    use DataAndExportControllerTrait;

    /**
     * Constructs a new instance of the class.
     *
     * @param ComputerByAgeService $service The ComputerByAgeService object.
     */
    public function __construct(protected ComputerByAgeService $service) {}

    /**
     * Show Computer By Age Report
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $ageFilterOptions = config('reports.computer_by_age_options.age_filter_options');

        return view('reports.computer-by-age.index', ['ageFilterOptions' => $ageFilterOptions]);
    }
}
