<?php
namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Services\Reports\AverageTimeInBrandNewService;
use Carbon\Carbon;
use Illuminate\Http\Request;

class AverageTimeInBrandNewController extends Controller
{
    protected $service;

    /**
     * Constructor for the class.
     *
     * @param AverageTimeInBrandNewService $service The service object.
     */
    public function __construct(AverageTimeInBrandNewService $service)
    {
        $this->service = $service;
    }

    /**
     * Report page 
     * 
     * @return View
     */
    public function index()
    {
        $year = $year = Carbon::now()->year;

        return view('reports.average-time-in-brand-new.index', compact('year'));
    }

    /**
     * Show graphical represntation of the report
     * @param Request $request
     * 
     * @return json
     */
    public function graphData(Request $request)
    {
        $year = ($request->year!='') ? $request->year : date('Y');
        $averageTimeIndepotData = $this->service->averageTimeInBrandNewData($year);
        $averageTimeIndepotData['year']=$year;

        return json_encode(compact('averageTimeIndepotData'));
    }
}
