<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\AvailableStockService;
use Illuminate\Http\Request;

class AvailableStockController extends Controller
{
    /**
     * Constructor for the class.
     *
     * @param AvailableStockService $service The available stock service object.
     */
    public function __construct(protected AvailableStockService $service)
    {
    }

    /**
     * List page for available stock report.
     */
    public function index()
    {
        $filterDataOptions = $this->service->getFilterDataOptions();

        return view('reports.available-stock.index', compact('filterDataOptions'));
    }

    /**
     * generates data for available stock report
     */
    public function data(Request $request)
    {
        $filteredData = $this->service->data();
        $stocks = $filteredData['stocks'];
        $data = [];

        if (!empty($stocks)) {
            $data = $this->service->getReportData($stocks, request('start'));
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count'], number_format($filteredData['totalAssetCount']));
    }

    /**
     * export for available stock report
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();

        $data = [];
        $datas = collect();
        $stocks = $this->service->exportData();
        
        $stocks->chunk(5000, function ($chunks) use ($data, $datas) {
            $datas->push($this->service->getReportExportData($chunks, $data));
        });
        
        return exportToCsv($datas->toArray());
    }
}
