<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\AssetsReusedService;

class AssetsReusedController extends Controller
{
    use DataAndExportControllerTrait;
    /**
     * Constructs a new instance of the class.
     *
     * @param AssetsReusedService $service The service to be injected.
     */
    public function __construct(protected AssetsReusedService $service) {}

    /**
     * Index function.
     *
     * @return mixed
     */
    public function index()
    {
        $reusedCount = $this->service->getReUsedAssetCount();
        $notReusedCount = $this->service->getNotReUsedAssetCount();

        return view('reports.reused-devices.asset-reused', ['reusedCount' => $reusedCount, 'notReusedCount' => $notReusedCount]);
    }

    /**
     * Generates a pie chart for the reused and not reused asset counts.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View The generated pie chart view.
     */
    public function pieChart()
    {
        $reusedCount = $this->service->getReUsedAssetCount();
        $notReusedCount = $this->service->getNotReUsedAssetCount();

        return view('reports.reused-devices.pie-chart', ['reusedCount' => $reusedCount, 'notReusedCount' => $notReusedCount]);
    }
}
