<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\AssetsCreatedService;

class AssetsCreatedController extends Controller
{
    use DataAndExportControllerTrait;

    /**
     * Constructs a new instance of the class.
     *
     * @param AssetsCreatedService $service The AssetsCreatedService instance.
     */
    public function __construct(protected AssetsCreatedService $service) {}

    /**
     * Loading the Page for the report 
     *
     * @return view file
     */
    public function index()
    {
        $inputData = $this->service->getInputData();
        $dateFrom = $this->service->getFromDate($inputData)->format('m/d/Y');
        $dateTo = $this->service->getToDate($inputData)->format('m/d/Y');

        return view('reports.assets-created.index', compact('dateFrom', 'dateTo'));
    }

    /**
     * Show graphical represntation of the report
     * @param Request $request
     * 
     * @return json
     */
    public function graphData()
    {
        $datas = $this->service->getGraphData();
        $graphData = $datas['data'];
        $monthNames = $datas['months'];
        $assetTypes = $datas['assetTypes'];
        $chartHtml = view('reports.assets-created.partials.chart', ['graphData' => $graphData, 'assetTypes' => $assetTypes])->render();

        return json_encode(compact('chartHtml', 'graphData', 'monthNames', 'assetTypes'));
    }
}
