<?php

namespace App\Http\Controllers\Reports;

use App\Http\Controllers\Controller;
use App\Http\Traits\DataAndExportControllerTrait;
use App\Services\Reports\AssetRecoveryValueService;

/**
 * A report to show recycle eligible assets with more than 3 years old.
 */
class AssetRecoveryValueController extends Controller
{
    use DataAndExportControllerTrait;
    protected $service;

    /**
     * Constructor method.
     *
     * @param AssetRecoveryValueService $service asset recovery value service.
     */
    public function __construct(AssetRecoveryValueService $service)
    {
        $this->service = $service;
    }

    /**
     * Display index page.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $widgetCountData = $this->service->getWidgetCountData();
        return view('reports.asset-recovery-value.index', compact('widgetCountData'));
    }

    /**
     * Get widget count dynamically for report
     * 
     * @return json response
     */
    public function getWidgetCount()
    {
        $widgetCountData = $this->service->getWidgetCountData();
        return response()->json($widgetCountData);
    }
}
