<?php

namespace App\Http\Controllers\Reports;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Services\Reports\AssetRecoveryService;

class AssetRecoveryController extends Controller
{
    
    protected $service;
    
    /**
     * __construct
     *
     * @param  AssetRecoveryService $aservice
     * @return void
     */
    public function __construct(AssetRecoveryService $service)
    {
        $this->service = $service;
    }
    
    /**
     * Report page
     * 
     * @return view page
     */
    public function index()
    {
        return view('reports.asset-recovery.asset-recovery');
    }

    /**
     * fetch the data to the report data table and graph
     * @return Http\Response
     * 
     */
    public function data(Request $request)
    { 
        $filteredData = $this->service->data();

        $assets =  $filteredData['assets'];
        $data = [];
        
        if (!empty($assets)) {
            $data = $this->service->getReportData($assets, request('start'));
        }
        $graphData = $this->service->getGraphData();

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count'], $graphData);
    }

    /**
     * Export asset recovery data     
     * @return csv
     */
    public function export()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $data = [];
        $datas = collect();
        $assets = $this->service->exportData();
        $assets->chunk(5000, function ($assetChunks) use ($data, $datas){
            $datas->push($this->service->getReportExportData($assetChunks, $data));
        });

        return exportToCsv($datas->toArray());
    }
}