<?php

namespace App\Http\Controllers\Reports;

use App\Models\Department;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cache;
use App\Services\Reports\ActiveUsersService;
use App\Http\Traits\DataAndExportControllerTrait;
/**
 * Controller class for Active Users Without Assets Report
 */
class ActiveUsersController extends Controller
{
    use DataAndExportControllerTrait;
    /**
     * Constructor for the class.
     *
     * @param ActiveUsersService $service The ActiveUsersService object.
     */
    public function __construct(protected ActiveUsersService $service) {}

    /**
     * Displays a list of Active Users with No Assets Assigned.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $departments = Cache::remember('departments', 3600, function () {
            return Department::select('id', 'name')->orderBy('name')->get();
        });
        return view('reports.active-users-with-no-assets.index', ['departments' => $departments]);
    }
}
