<?php

namespace App\Http\Controllers;

use App\Models\AssetStatus;
use Facades\App\Repositories\AssetRepository;
use App\Models\Asset;
use App\Models\Carrier;
use App\Services\Asset\SearchAssetService;
use App\Services\AssetsHealth\AssetsHealthReportService;
use Exception;
use Facades\App\Services\Asset\AssetStatusService;

class MobileManagementController extends Controller
{
    public function __construct(protected AssetsHealthReportService $assetsHealthReportService, protected SearchAssetService $searchAssetService) {}


    public function index()
    {
        $breadcrumbTitle = 'Mobile Assets';
        $type = 'mobile';
        $searchText = request('searchText');

        $searchResults = $this->searchAssetService->getSearchedAssets($searchText, 'mobile_phone');

        $statuses = AssetStatus::orderBy('slug')->get();
        request()->flash();

        $adminStatus = $this->searchAssetService->determineAdminStatus();

        $carriers = Carrier::get();

        return view('assets.search.index', array_merge($searchResults, compact(
            'statuses',
            'breadcrumbTitle',
            'type',
            'adminStatus',
            'carriers'
        )));
    }

    /** Shows detail page of mobile assets
     * @param mixed $id
     *
     * @return [type]
     */
    public function show($id)
    {
        try {
            $asset = Asset::with('location', 'user', 'assetType', 'makeAndModel.manufacturer', 'technicalSpec', 'assetStatus', 'parentAsset', 'carrier', 'assetHistory:id,action,user_id,asset_id,created_at,updated_at,ticket_no', 'assetTypeAttributeValue', 'airwatch', 'chromebook', 'jamf', 'intune')->find($id);
            $statuses = AssetStatusService::availableStatusesForUpdate($asset->assetStatus?->slug) ?? [];
        } catch (Exception $e) {
            return redirect('/assets')->with('error', 'No Asset Found');
        }
        $carriers = Carrier::get();
        $data = ['title' => 'Mobile Asset Detail', 'parent' => 'Mobile Assets', 'type' => 'mobile', 'parentUrl' => route('assets.mobile')];

        $user = AssetRepository::searchAssetUser();
        $assetHealth = $this->assetsHealthReportService->getAssetHealthDetailByAsset($id);

        return view('assets.detail-page.detail-index', compact('asset', 'data', 'statuses', 'user', 'carriers', 'assetHealth'));
    }
}
