<?php

namespace App\Http\Controllers\Location;

use App\Http\Controllers\Controller;
use App\Http\Responses\ReportJsonResponse;
use App\Services\Location\LocationZoomDeviceService;

class LocationZoomDeviceController extends Controller
{
    /**
     * Constructor
     *
     * @param LocationZoomDeviceService $service The service for location zoom devices list.
     */
    public function __construct(protected LocationZoomDeviceService $service) {}

    /**
     * Get the data for 'Zoom Devices in Location' list.
     *
     * @return ReportJsonResponse
     */
    public function data()
    {
        $filteredData   = $this->service->data();
        $assets         = $filteredData['assets'];
        $totalData      = $filteredData['count'];
        $data           = [];

        if (!empty($assets)) {
            $data = $this->service->getLocationZoomData($assets, request('start'), $data);
        }

        return new ReportJsonResponse(request()->input('draw'), $data, $totalData);
    }
}
