<?php

namespace App\Http\Controllers\Location;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Asset;
use App\Services\Location\LocationAssetData;
use App\Repositories\AssetRepository;
use App\Http\Responses\ReportJsonResponse;

class LocationAssetsController extends Controller
{
    public function __construct(protected LocationAssetData $service, protected AssetRepository $assetRepository)
    {
    }
    /** lists the assets in the location
     * @param Request $request
     *
     * @return [type]
     */
    public function data(Request $request)
    {

        $filteredData   = $this->service->locationAssetsFilter();
        $assets         =  $filteredData['assets'];

        $start          = request('start');
        $data           = [];

        if (!empty($assets)) {
            $data = $this->service->getLocationAssetData($assets, $start, $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count'], 500);
    }

    /** Gets the total value of assets in the location
     * @param mixed $location
     *
     * @return [type]
     */
    public function assetValue($location)
    {
        $assets = Asset::where('location_id', $location)->get();
        $locationSum = $this->assetRepository->sumOriginal($assets->pluck('id'));

        return $locationSum;
    }
}
