<?php

namespace App\Http\Controllers\Location;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\Location\LocationAccessoryData;
use App\Http\Responses\ReportJsonResponse;

class LocationAccessoriesController extends Controller
{
    public function __construct(protected LocationAccessoryData $service)
    {
    }

    /** lists the accessories in the location
     * @param Request $request
     * 
     * @return [type]
     */
    public function data(Request $request)
    {

        $filteredData   = $this->service->locationAccessoriesFilter();
        $accessories         =  $filteredData['accessories'];

        $start          = request('start');
        $data           = [];

        if (!empty($accessories)) {
            $data = $this->service->getLocationAccessoriesData($accessories, $start, $data);
        }

        return new ReportJsonResponse($request->input('draw'), $data, $filteredData['count'], 500);
    }
}
