<?php

namespace App\Http\Controllers;

use App\Models\Asset;
use App\Models\AssetStatus;
use Facades\App\Services\Reports\Dashboard;
use Carbon\Carbon;
use App\Models\Region;
use App\Models\AssetType;
use Cache;
use App\User;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    public function index()
    {
        $user = User::with('userType')->find(Auth::id());

        if ($user->hasRole('Employee')) {
            return redirect(route('my-teq-assets'));
        }

        $count = [
            'total_assets'          => Asset::count(),
            'inactivePersons'       => Asset::inActiveUsers()->count(),
            'inactiveLocations'     => Asset::inActiveLocations()->count(),
            'ageOverFourYears'      => Asset::ageOverFourYears()->count(),
            'damagedOverThirtyDays' => Asset::damagedOverThirtyDays()->count(),
            'lost_stolen_asset'     => Asset::lostStolenAssetWithoutDataWipe()->count(),
            'end_of_life_asset'     => Asset::endOfLifeWithoutCertificate()->count(),
            'loaner_due_week'       => Dashboard::loanerDueWeek()->count(),
            'loaner_past_due'       => Dashboard::loanerPastDue()->count(),
            'retention_due_week'    => Dashboard::retentionDueWeek()->count(),
            'retention_past_due'    => Dashboard::retentionPastDue()->count(),
            'lease_due_week'        => Dashboard::leaseDueWeek()->count(),
            'lease_past_due'        => Dashboard::leasePastDue()->count(),
            'used_new_asset'        => Dashboard::assetsInStatuses(['brand_new', 'used', 'used_loaner'])->count(),
        ];

        $assetStatuses = AssetStatus::withCount('assets')->orderBy('slug')->get();

        foreach ($assetStatuses as $status) {
            $count[$status->slug] = Dashboard::assetsInStatus($status->id)->count();

            $donutAllStatusData[] = ['label' => $status->name, 'value' => $count[$status->slug]];

            if (in_array($status->slug, ['assigned', 'installed', 'loaned'])) {
                $donutSelectedStatusData[] = ['label' => $status->name, 'value' => $count[$status->slug]];
            }
        }

        $months   = get_past_month_names_short(first_day_current_month_last_year(), Carbon::now());
        $monthNames = collect($months)->flatten()->toArray();
        $assetLineGraphData = Dashboard::getAssetCreated($months);

        $regionTotalAssets = Cache::remember('region-total-assets', 120, function () {
            return Dashboard::getRegionTotalAssets()->get();
        });

        $assetsInRegion = $regionTotalAssets->mapWithKeys(function ($item) {
            return [$item['id'] => $item['count']];
        });

        foreach (Region::get() as $region) {
            $regionCount[] = [
                'count' => isset($assetsInRegion[$region->id]) ? $assetsInRegion[$region->id] : 0,
                'name'  => $region->name,
                'id'    => $region->id,
            ];
        }

        $assetTypes = AssetType::withCount('assets')->get();

        $widgetAssetStatus = ["Brand New Computers" => ["brand_new"], "Like New & Used Computers" => ["like_new", "used"]];

        foreach ($widgetAssetStatus as $statusName => $statusSlug) {
            $computersWidgetData[$statusName] = Dashboard::getComputerWidgetData($statusSlug);
        }

        return view('dashboard.index', compact('count', 'monthNames', 'assetLineGraphData', 'donutAllStatusData', 'donutSelectedStatusData', 'regionCount', 'assetTypes', 'assetStatuses', 'computersWidgetData'));
    }
}
