<?php

namespace App\Http\Controllers;

use App\Services\GitBookJwtService;
use Exception;
use Illuminate\Support\Facades\Log;

class HelpController extends Controller
{
    /**
     * Class constructor.
     *
     * This constructor initializes the class with a GitbookJwtService instance.
     *
     * @param GitBookJwtService $jwtService The GitbookJwtService instance.
     */
    public function __construct(protected GitBookJwtService $jwtService) {}


    /**
     * Redirect to the help guide URL with a JWT token.
     *
     * @return \Illuminate\Http\RedirectResponse The redirect response to the help guide URL or back in case of an error.
     */
    public function helpLink()
    {
        try {
            $jwtToken = $this->jwtService->generateJwtForGitBook('help');
            $helpUrl = optional(\App\Models\SystemSetting::where('slug', 'help_guide_url')->first())->value . '?jwt=' . $jwtToken;

            return redirect($helpUrl);
        } catch (Exception $e) {
            Log::channel('daily')->error($e->getMessage());

            return redirect()->route('dashboard');
        }
    }
}
