<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\FileExport;
use Exception;
use Illuminate\Support\Facades\Log;

class ExportManagementController extends Controller
{

	/**
	 * Show the generated exports
	 * @param string $reportType
	 *
	 * @return [type]
	 */
	public function fileExports($reportType = 'generator_report')
	{
		$userId = Auth::id();
		$generatedExportsList = FileExport::where(["user_id" => $userId, "report_type" => $reportType])->orderBy('id', 'desc')->get();

		return view('file-exports.file-exports', compact('generatedExportsList', 'reportType'));
	}

	/**
	 * markAsDownloaded - mark as download and delete the file
	 *
	 * @param  mixed $reportId
	 * @return void
	 */
	public function markAsDownloaded($reportId)
	{
		try {
			$exportedReportData = FileExport::where('id', $reportId);
			$reportName = $exportedReportData->first()->report_url;
			$exportedReportData->delete();

			unlink(storage_path('app/public/export_reports/' . $reportName));
			session()->flash('message', 'Report removed successfully.');

			return response()->json(['success' => true]);
		} catch (Exception $e) {
			session()->flash('message', 'File not found!');

			return response()->json(['success' => false]);
		}
	}
}
